%------------------------------------------------------------------------------
% File     : RAL039^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Real Algebra (Quadratic equations)
% Problem  : International Mathematical Olympiad, 2003, Problem 2
% Version  : [Mat16] axioms : Especial.
% English  : Find all pairs (m, n) of positive integers such that m^2 / (2 m 
%            n^2 - n^3 + 1) is a positive integer.

% Refs     : [Mat16] Matsuzaki (2016), Email to Geoff Sutcliffe
%          : [MI+16] Matsuzaki et al. (2016), Race against the Teens - Benc
% Source   : [Mat16]
% Names    : IMO-2003-2.p [Mat16]

% Status   : Theorem
% Rating   : ? v7.0.0
% Syntax   : Number of formulae    : 3485 ( 711 unt;1199 typ;   0 def)
%            Number of atoms       : 7880 (2209 equ;   0 cnn)
%            Maximal formula atoms :   40 (   3 avg)
%            Number of connectives : 39643 ( 104   ~; 233   |;1176   &;36004   @)
%                                         (1095 <=>;1031  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   8 avg)
%            Number arithmetic     : 4488 ( 374 atm;1215 fun; 961 num;1938 var)
%            Number of types       :   40 (  36 usr;   3 ari)
%            Number of type conns  : 2408 (2408   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 1212 (1169 usr;  66 con; 0-9 aty)
%            Number of variables   : 8058 ( 406   ^;7085   !; 431   ?;8058   :)
%                                         ( 136  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_ARI

% Comments : Theory: PA; Score: 7; Author: Yiyang Zhan;
%            Generated: 2014-11-19
%          : Answer
%            ^ [V_mn_dot_0: ( 'ListOf' @ $int )] :
%            ? [V_l: $int] :
%              ( ( $greater @ V_l @ 0 )
%              & ( ( V_mn_dot_0
%                  = ( 'cons/2' @ $int @ ( $product @ 2 @ V_l ) @ ( 'cons/2' @ $int @ V_l @ ( 'nil/0' @ $int ) ) ) )
%                | ( V_mn_dot_0
%                  = ( 'cons/2' @ $int @ V_l @ ( 'cons/2' @ $int @ ( $product @ 2 @ V_l ) @ ( 'nil/0' @ $int ) ) ) )
%                | ( V_mn_dot_0
%                  = ( 'cons/2' @ $int @ ( $difference @ ( $product @ 8 @ ( 'int.^/2' @ V_l @ 4 ) ) @ V_l ) @ ( 'cons/2' @ $int @ ( $product @ 2 @ V_l ) @ ( 'nil/0' @ $int ) ) ) ) ) ) )
%------------------------------------------------------------------------------
include('Axioms/MAT001^0.ax').
%------------------------------------------------------------------------------
thf(p_qustion,conjecture,
    ( 'find/1' @ ( 'ListOf' @ $int )
    @ ^ [V_mn: 'ListOf' @ $int] :
      ? [V_m: $int,V_n: $int] :
        ( ( V_mn
          = ( 'cons/2' @ $int @ V_m @ ( 'cons/2' @ $int @ V_n @ ( 'nil/0' @ $int ) ) ) )
        & ( $greater @ V_m @ 0 )
        & ( $greater @ V_n @ 0 )
        & ( 'int.is-divisible-by/2' @ ( 'int.^/2' @ V_m @ 2 ) @ ( $sum @ ( $product @ 2 @ ( $product @ V_m @ ( $product @ V_n @ V_n ) ) ) @ ( $sum @ ( $uminus @ ( 'int.^/2' @ V_n @ 3 ) ) @ 1 ) ) )
        & ( $greater @ ( $sum @ ( $product @ 2 @ ( $product @ V_m @ ( $product @ V_n @ V_n ) ) ) @ ( $sum @ ( $uminus @ ( 'int.^/2' @ V_n @ 3 ) ) @ 1 ) ) @ 0 ) ) ) ).

%------------------------------------------------------------------------------
